/* $Id: part_num_probe.c,v 1.1 1997/04/25 17:53:00 dps Exp $ */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */
#ifdef HAVE_CTYPE_H
#include <ctype.h>
#endif /* HAVE_CTYPE_H */

/* Find part number and return it or -1 if no number */
int get_part_num(const char *st, const char *fence)
{
    int n;

    while (st<fence)
    {
	if (isspace(*st))
	{
	    st++;
	    continue;
	}
	if (isdigit(*st))
	{
	    n=0;
	    while (st<fence && isdigit(*st))
	    {
		n=n*10+(*st)-'0';
		st++;
	    }
	    if (!isspace(*st))
		return -1;
	    else
		return n;

	}
	if (isupper(*st) && isspace(*(st+1)))
	    return (*st)-'A'+1;

	if (islower(*st) && isspace(*(st+1)))
	    return (*st)-'a'+1;

	/* Nothing else understood at this time */
	return -1;
    }
    return -1;
}
