/*
 * Decompiled with CFR 0.152.
 */
package javaTeX;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javaTeX.PsFontFile;

public class TeXFile
extends File {
    static String TEXMF = "/usr/local/lib/texmf";
    static String TEXHASH = "tex.hash";
    static String slash = "/";
    static String colon = ":";
    static Properties properties;
    static File propFile;
    static String tempName;
    static Hashtable fileStore;
    String fileName;
    String fullName = tempName;
    String realName;

    private static String getFullName(String string) {
        String string2;
        String string3;
        String string4;
        int n = string.indexOf(58);
        if (n >= 0) {
            string4 = string.substring(n + 1);
            string3 = string.substring(0, n);
        } else {
            string4 = string;
            string3 = "";
        }
        File file = new File(string4);
        if (file.exists()) {
            return string4;
        }
        if (string3.equals("PSFONTS")) {
            if (PsFontFile.hashTable == null) {
                PsFontFile.initHash();
            }
            if ((string2 = (PsFontFile)PsFontFile.hashTable.get(string4)) != null) {
                string4 = string4 + ".tfm";
            } else {
                return "";
            }
        }
        TeXFile.initHash();
        string2 = (String)fileStore.get(string4);
        tempName = string2 != null ? string2 + slash + string4 : "";
        return tempName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void initHash() {
        boolean bl = false;
        if (fileStore != null) {
            return;
        }
        String string = System.getProperty("user.home");
        String string2 = System.getProperty("java.home");
        slash = System.getProperty("file.separator");
        colon = System.getProperty("path.separator");
        String string3 = "properties";
        propFile = new File(string3);
        if (!propFile.exists() && !(propFile = new File(string3 = string + slash + ".javaTeX" + slash + "properties")).exists()) {
            string3 = string2 + slash + "javaTeX.properties";
            propFile = new File(string3);
        }
        if (propFile.exists()) {
            properties = new Properties();
            try {
                DataInputStream dataInputStream = new DataInputStream(new FileInputStream(propFile));
                if (dataInputStream != null) {
                    properties.load(dataInputStream);
                }
                TEXMF = properties.getProperty("TEXMF", "/usr/local/lib/texmf");
                TEXHASH = properties.getProperty("TEXHASH", "tex.hash");
            }
            catch (IOException iOException) {
                System.err.println("Problem reading properties file " + string3 + ": " + iOException.getMessage());
            }
        }
        fileStore = new Hashtable();
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(TEXMF, colon);
        block7: while (stringTokenizer.hasMoreTokens()) {
            Closeable closeable;
            File file;
            String string4;
            String string5 = stringTokenizer.nextToken();
            File file2 = new File(string5);
            if (!file2.exists()) {
                System.err.println("Cannot find TEXMF=" + string5);
                System.err.println("Please edit your \"properties\" file");
                System.exit(1);
            }
            if (n++ == 0) {
                string4 = TEXHASH;
                file = new File(string4);
                if (!file.exists()) {
                    string4 = TEXMF + slash + "tex.hash";
                    file = new File(string4);
                }
                if (file.exists()) {
                    System.out.print(" (" + string4);
                    closeable = null;
                    try {
                        closeable = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
                        fileStore = (Hashtable)((ObjectInputStream)closeable).readObject();
                        ((ObjectInputStream)closeable).close();
                    }
                    catch (IOException iOException) {
                        System.err.println("Problem reading \"tex.hash\": " + iOException.getMessage());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        System.err.println("Problem reading \"tex.hash\": " + classNotFoundException.getMessage());
                    }
                    System.out.print(") ");
                    return;
                }
            }
            if (!(file = new File(string4 = string5 + slash + "ls-R")).exists()) {
                System.err.println(" Must have file \"$TEXMF/ls-R\" for javaTeX");
                System.exit(1);
            }
            closeable = null;
            System.out.print(" (" + string4);
            try {
                closeable = new BufferedReader(new FileReader(string4));
                String string6 = "";
                String string7 = "";
                while (true) {
                    if ((string6 = ((BufferedReader)closeable).readLine()) == null) {
                        ((BufferedReader)closeable).close();
                        System.out.print(") ");
                        continue block7;
                    }
                    if (string6.equals("")) continue;
                    if (string6.endsWith(colon)) {
                        string7 = string5 + string6.substring(1, string6.length() - 1);
                        continue;
                    }
                    fileStore.put(string6, string7);
                }
            }
            catch (IOException iOException) {
                System.err.println("Problem reading ls-R: " + iOException.getMessage());
                System.exit(1);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void makeHash() {
        Object object;
        String string = System.getProperty("user.home");
        String string2 = System.getProperty("java.home");
        slash = System.getProperty("file.separator");
        colon = System.getProperty("path.separator");
        String string3 = "properties";
        propFile = new File(string3);
        if (!propFile.exists() && !(propFile = new File(string3 = string + slash + ".javaTeX" + slash + "properties")).exists()) {
            string3 = string2 + slash + "javaTeX.properties";
            propFile = new File(string3);
        }
        if (propFile.exists()) {
            properties = new Properties();
            try {
                object = new DataInputStream(new FileInputStream(propFile));
                if (object != null) {
                    properties.load((InputStream)object);
                }
                TEXMF = properties.getProperty("TEXMF", "/usr/local/lib/texmf");
                TEXHASH = properties.getProperty("TEXHASH", "tex.hash");
            }
            catch (IOException iOException) {
                System.err.println("Problem reading properties file " + string3 + ": " + iOException.getMessage());
            }
        }
        fileStore = new Hashtable();
        object = new StringTokenizer(TEXMF, colon);
        while (((StringTokenizer)object).hasMoreTokens()) {
            String string4 = ((StringTokenizer)object).nextToken();
            System.err.println();
            System.err.println("(" + string4 + ")");
            TeXFile.dirList(string4);
        }
        System.err.println();
        TeXFile.saveHash();
    }

    public static void dirList(String string) {
        File file = new File(string);
        if (!file.exists() || !file.isDirectory()) {
            return;
        }
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            if (!stringArray[n].startsWith(".")) {
                File file2 = new File(file, stringArray[n]);
                if (file2.isFile()) {
                    fileStore.put(stringArray[n], string);
                } else if (file2.isDirectory()) {
                    System.err.print(".");
                    String string2 = string + slash + stringArray[n];
                    TeXFile.dirList(string2);
                }
            }
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void saveHash() {
        File file = new File("tex.hash");
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
            objectOutputStream.writeObject(fileStore);
            return;
        }
        catch (IOException iOException) {
            System.err.println("Problem saving hash-table: " + iOException.getMessage());
        }
    }

    public TeXFile(String string) {
        super(TeXFile.getFullName(string));
    }
}

