procedure FreeLigRecord(var ptrLig : ptrLigRecord;
                        flbound : boolean);
var ptrL, ptrLH, pLH : ptrLigRecord;
begin
     ptrL:=ptrLig; ptrLH:=nil;
     while ptrL <> nil do
     begin
          {
          if ptrL^.marked = LigUsedBound then FlBoundCharGlb:=true;
          }
          if not (ptrL^.marked in [LigAdded, LigUsed, LigUsedBound]) then
          begin
               pLH:=ptrL; ptrL:=ptrL^.ptrNext;
               dispose(pLH);
               if ptrLH <> nil then ptrLH^.ptrNext:=ptrL
                               else ptrLig:=ptrL;
          end
          else begin
               ptrL^.marked:=LigUsed;
               if flbound then
               begin
                    case ptrL^.TTLig of
                    TKern : if ptrL^.KernChar = BoundCharGlb
                               then FlBoundCharGlb:=true;
                    TLig, TSLig,
                    TSLigH, TLigS,
                    TLigSH, TSLigS,
                    TSLigSH, TSLigSHH : if ptrL^.NextChar = BoundCharGlb
                                           then FlBoundCharGlb:=true;
                    end; {case}
               end;

               ptrLH:=ptrL;
               ptrL:=ptrL^.ptrNext;
          end;
     end; {while}
     if ptrLH <> nil then ptrLH^.ptrNext:=nil;
end; {FreeLigTable}

procedure MarkSkipRecord(var ptrLig : ptrLigRecord);
var ptrLTrace, ptrL, pLH,
    ppLig, ppLigP, ppSkip : ptrLigRecord;
    i, j : integer;
    fl, flSkip, flSK, flEmpty, flSkipEmpty : boolean;
    ich : byte;
begin

     ptrLTrace:=ptrLig; ptrL:=nil;
     while ptrLTrace <> nil do
     begin
          if (ptrLTrace^.TTLig in [TStop, TSkip])
                and (ptrLTrace^.marked in [LigUsed, LigUsedBound, LigAdded])
          then ptrLTrace^.marked:=LigNotUsed;

          ptrL:=ptrLTrace;
          ptrLTrace:=ptrLTrace^.ptrNext;
     end; {while}

     ptrLTrace:=ptrLig; ptrL:=nil;
     while ptrLTrace <> nil do
     begin
          if (ptrLTrace^.marked in [LigAdded, LigUsed, LigUsedBound])
            and (ptrLTrace^.TTLig in [TLabel, TLabelBoundary]) then
          begin
               i:=1; j:=0; ich:=ptrL^.LigChar;
               pLH:=ptrL; ptrL:=ptrLTrace;
               ppLig:=nil; ppLigP:=nil; ppSkip:=nil;
               fl:=true; flSkip:=false; flSK:=false;
               flEmpty:=true; flSkipEmpty:=true;

               while (ptrL <> nil) and fl do
               begin
                    if (i <= j) then
                    begin
                        if ptrL^.TTLig in [TKern, TLig, TSLig,
                                           TSLigH, TLigS, TLigSH,
                                           TSLigS, TSLigSH,
                                           TSLigSHH]
                        then begin

                             i:=i+1;
                             if ptrL^.marked = LigAdded then j:=j+1;

                             if i > j then
                             begin
                                if flSK and (ppSkip <> nil)
                                   then ppSkip^.marked:=LigUsed;
                             end;

                             if ptrL^.marked in
                                   [LigAdded, LigUsed, LigUsedBound]
                             then begin
                                  flSK:=true;
                                  if i > j then
                                  begin
                                       if flEmpty and flSkip then
                                       begin
                                            ppLig:=ptrL; ppLigP:=pLH;
                                       end;
                                       flEmpty:=false; flSkipEmpty:=false;
                                  end;
                             end;

                        end;
                     end
                     else if ptrL^.TTLig = TStop then fl:=false
                     else if ptrL^.TTLig = TSkip then
                     begin
                          if not flSkipEmpty then ppSkip:=ptrL;
                          flSK:=false; flSkip:=true; flSkipEmpty:=true;
                          i:=0; j:=ptrL^.SkipNum;
                     end
                     else if not(ptrL^.TTLig in [TLabel, TLabelBoundary])
                     then begin {Kern, Lig}
                          if (ptrL^.marked in
                                    [LigAdded, LigUsed, LigUsedBound])
                          then begin
                               if flSkip and flEmpty then
                               begin
                                    ppLig:=ptrL; ppLigP:=pLH;
                               end;
                               flEmpty:=false; flSkipEmpty:=false;
                          end;
                     end;

                     if fl then
                     begin
                          pLH:=ptrL; ptrL:=ptrL^.ptrNext;
                     end;

               end; {while Skip}

               {--- Check correctness -----}
               if ptrL <> nil then
               begin
                    if not FlSkipEmpty then ptrL^.marked:=LigUsed
                    else
                    if ppSkip <> nil then
                    begin
                         ppSkip^.TTLig:=TStop;
                         ppSkip^.marked:=LigUsed;
                    end
                    else
                    ptrLTrace^.marked:=LigNotUsed;
               end
               else begin
                    ErrorLog('*** Error : LIGTABLE for character '+ConvChar(ich)+' is unfinished.');
                    ErrorLog('               Corresponding LABEL is deleted.');
                    ptrLTrace^.marked:=LigDiscard; FlagError:=true;
               end;

               if ppLig <> nil then
               begin
                    {--- move label before ptrL ---}
                    new(pLH); pLH^:=ptrLTrace^;
                    ptrLTrace^.marked:=LigNotUsedM;
                    pLH^.marked:=LigUsed;

                    pLH^.ptrNext:=ppLig;
                    if ppLigP <> nil then ppLigP^.ptrNext:=pLH;
               end;

          end; {used Label}

          ptrL:=ptrLTrace;
          ptrLTrace:=ptrLTrace^.ptrNext;

     end; {while}

end; {MarkSkipRecord}


procedure UpdateSkipRecord(var ptrLig : ptrLigRecord);
var ptrL, ptrLH, pLH : ptrLigRecord;
    i, j, k : integer;
    fl : boolean;
begin

     ptrL:=ptrLig; pLH:=nil;
     while ptrL <> nil do
     with ptrL^ do
     begin
          if (TTLig = TSkip) and (marked in [LigUsed, LigUsedBound, LigAdded])
          then begin
             if (pLH = nil) or (pLH^.TTLig in [TSkip, TStop])
             then begin
                  marked:=LigNotUsed;
             end
             else begin

                  i:=1; j:=0; k:=0; ptrLH:=ptrL; fl:=true;

                  while (ptrLH <> nil) and fl do
                  begin
                       if (i <= j) then
                       begin
                          if ptrLH^.TTLig in [TKern, TLig, TSLig,
                                            TSLigH, TLigS, TLigSH,
                                            TSLigS, TSLigSH,
                                            TSLigSHH]
                          then begin
                               i:=i+1;
                               if ptrLH^.marked = LigAdded then j:=j+1;
                               if ptrLH^.marked in
                                         [LigUsed, LigUsedBound, LigAdded]
                               then begin
                                    if (i > j) then fl:=false
                                               else k:=k+1;
                               end;
                          end;
                       end
                       else if ptrLH^.TTLig = TStop then fl:=false
                       else
                       if ptrLH^.TTLig = TSkip then
                       begin
                            i:=0; j:=ptrLH^.SkipNum;
                       end
                       else
                       if not (ptrLH^.TTLig in [TLabel, TLabelBoundary]) then
                       begin {Kern, Lig}
                            fl:=(ptrLH^.marked in [LigNotUsed, LigNotUsedM, LigDiscard]);
                       end;

                       if fl then ptrLH:=ptrLH^.ptrNext;

                  end; {while Skip}

                  if ptrL^.SkipNum = 0 then ptrL^.marked:=LigAdded;

                  if (ptrL^.marked <> LigAdded)
                      and (k <> ptrL^.SkipNum)
                      and (ptrL^.SkipNum <> 0)
                  then begin
                      new(pLH);
                      pLH^:=ptrL^; pLH^.marked:=LigAdded;
                      ptrL^.ptrNext:=pLH; ptrL^.marked:=LigNotUsedM;
                      ptrL:=pLH;
                  end;

                  if (ptrLH = nil) then
                  begin
                       ErrorLog('*** Error : SKIP exits outside LIGTABLE');
                       ErrorLog('              SKIP is changed to STOP');
                       ptrL^.TTLig:=TStop; FlagError:=true;
                  end
                  else
                  if (ptrLH^.TTLig = TStop) then
                  begin
                       ErrorLog('*** Error : SKIP --> STOP (so, SKIP is changed to STOP');
                       ptrL^.TTLig:=TStop; FlagError:=true;
                  end
                  else begin
                       ptrL^.SkipNum:=k;
                       if k <= 0 then
                       begin
                            ErrorLog('*** Error : SKIP D 0 is included in LIGTABLE');
                            FlagError:=true;
                       end;
                  end;

             end;

          end; {if}

          pLH:=ptrL;
          ptrL:=ptrL^.ptrNext;
     end; {while}

end; {UpdateSkipRecord}


procedure TraceLigTableTable(ichar : integer;
                             var FLigNew, FLigEnd : ptrLigRecord);
var pLH, pLig : ptrLigRecord;
    i, j : integer;
var fl  : boolean;
begin

     fl:=false;
     if (ichar < 0) or (ichar > 256) then fl:=true
     else
     if CharIndexArr[ichar] = nil then fl:=true
     else
     if (ichar = 256) and (CharIndexArr[ichar]^.TTLig <> TLabelBoundary)
        then begin
             fl:=true;
             ErrorLog('*** Internal Error : CharIndex references to illegal record (LABEL BCHAR ?)');
        end
     else
     if (CharIndexArr[ichar]^.TTLig <> TLabel)
            or (CharIndexArr[ichar]^.LigChar <> ichar)
         then begin
              fl:=true;
              ErrorLog('*** Internal Error : CharIndex references to illegal record (LABEL ?)');
         end;

     if (not fl) then fl:=(not (CharIndexArr[ichar]^.marked
                             in [LigUsed, LigUsedBound, LigAdded]));

     if fl then
     begin
          FLigNew:=nil; FLigEnd:=nil;
          exit;
     end;

     pLig:=CharIndexArr[ichar]; pLig^.marked:=LigNotUsed;
     FLigNew:=nil; FLigEnd:=nil;

     fl:=true; i:=1; j:=0;
     while (pLig <> nil) and fl do
     begin

         if i <= j then
         begin
              if pLig^.TTLig in [TKern, TLig, TSLig, TSLigH,
                                 TLigS, TLigSH, TSLigS, TSLigSH,
                                 TSLigSHH]
                 then i:=i+1;
              if pLig^.marked = LigAdded then j:=j+1;
         end
         else begin
              case pLig^.TTLig of
              TStop : begin
                           fl:=false;
                      end;
              TSkip : begin
                      i:=0; j:=pLig^.SkipNum;
                      end;
              TLabel, TLabelBoundary : ;
              else begin {Kern/Lig}
                   if pLig^.marked in [LigUsed, LigUsedBound, LigAdded] then
                   begin
                        new(pLH); pLH^:=pLig^; pLH^.marked:=LigAdded;
                        pLH^.ptrNext:=nil;
                        if FLigNew = nil then
                        begin
                             FLigNew:=pLH; FLigEnd:=pLH;
                        end
                        else begin
                             FLigEnd^.ptrNext:=pLH;
                             FLigEnd:=pLH;
                        end;
                   end;
              end;
              end; {case}
         end;

         if fl then pLig:=pLig^.ptrNext;

     end; {while}

     if fl then
     begin
           ErrorLog('*** Error : LIG Program [input] for character '+ConvChar(ichar)+' has no STOP');
           FlagError:=true;
     end;

end; {TraceLigTableTable}


procedure JoinLastLigTables;
var ptrL, ptrLH, pLH : ptrLigRecord;
    FLigNew, FLigEnd : ptrLigRecord;
    ind, i, j, k : integer;
    fl : boolean;
begin

     {------ with additional ligtable :
               discard absent characters,
               create locator array,
               check that the 'boundarychar' is used
      -----}
      CheckLigTableTable(false);

     {------ add new records to LigMain and LigBound ---}
     if CharIndexArr[256] <> nil then
     begin {Add to LABEL BOUNDARYCHAR}
           TraceLigTableTable(256,FLigNew,FLigEnd);
           if FLigNew <> nil then
           begin
                FLigEnd^.ptrNext:=ptrLigBound;
                ptrLigBound:=FLigNew;
           end;
     end;

     ptrL:=ptrLigMain; ptrLH:=nil;
     while ptrL <> nil do
     begin
          if ptrL^.TTLig = TLabel then
          begin
              if CharIndexArr[ptrL^.LigChar] <> nil then
              begin {Add to LABEL}

                    TraceLigTableTable(ptrL^.LigChar,FLigNew,FLigEnd);
                    CharIndexArr[ptrL^.LigChar]:=nil;

                    {--- insert SKIP D 0 ---}
                    if (ptrLH <> nil) and (FLigNew <> nil)
                       and (not (ptrLH^.TTLig in [TSkip, TStop])) then
                    begin
                         new(pLH); pLH^.marked:=LigAdded;
                         pLH^.TTLig:=TSkip; pLH^.SkipNum:=0;
                         pLH^.ptrNext:=ptrLH^.ptrNext;
                         ptrLH^.ptrNext:=pLH;
                         ptrLH:=pLH;
                    end;

                    {--- insert chain of commands ---}
                    if FLigNew <> nil then
                    begin
                         FLigEnd^.ptrNext:=ptrL^.ptrNext;
                         ptrL^.ptrNext:=FLigNew;
                         ptrL:=FLigEnd;
                    end;

              end;
          end;

          ptrLH:=ptrL;
          ptrL:=ptrL^.ptrNext;
     end; {while}


     {---- Update SKIP's for Main LigTable ---}
     MarkSkipRecord(ptrLigMain);
     UpdateSkipRecord(ptrLigMain);

     {------ Trace elements of TABLE LigTable ------}
     ptrL:=ptrLigTable;
     while ptrL <> nil do
     begin
         if (ptrL^.TTLig <> TLabel)
             and (ptrL^.marked in [LigUsed, LigUsedBound, LigAdded])
         then ptrL^.marked:=LigNotUsed;
         ptrL:=ptrL^.ptrNext;
     end; {while ptrL}

     ptrL:=ptrLigTable;
     while ptrL <> nil do
     begin
           if (ptrL^.TTLig in [TLabel, TLabelBoundary])
               and (ptrL^.marked in [LigUsed, LigUsedBound, LigAdded])
           then begin

                ptrLH:=ptrL; fl:=true; i:=1; j:=0;
                while (ptrLH <> nil) and fl do
                begin
                     if i <= j then
                     begin
                          if ptrLH^.TTLig in [TKern, TLig, TSLig, TSLigH,
                                              TLigS, TLigSH, TSLigS, TSLigSH,
                                              TSLigSHH]
                             then i:=i+1;
                     end
                     else
                     if ptrLH^.TTLig = TStop then fl:=false
                     else
                     if ptrLH^.TTLig = TSkip then
                     begin
                          i:=0; j:=ptrLH^.SkipNum;
                     end
                     else {Lig, Kern}
                     if not (ptrLH^.TTLig in [TLabel, TLabelBoundary]) then
                     begin
                          if ptrLH^.marked = LigNotUsed
                             then ptrLH^.marked:=LigUsed;
                     end;

                     if fl then ptrLH:=ptrLH^.ptrNext;

                end; {-- tracing --}

                if fl then
                begin
                    ErrorLog('*** Error : LIGTABLE for character '+ConvChar(ptrL^.LigChar)+' is unfinished.');
                    ErrorLog('               Corresponding LABEL is deleted.');
                    ptrL^.marked:=LigDiscard; FlagError:=true;
                end;

           end; {if TLabel and marked}

           ptrL:=ptrL^.ptrNext;
     end; {while ptrL}

     {------ Update Skip Records ------}
     MarkSkipRecord(ptrLigTable);
     UpdateSkipRecord(ptrLigTable);

end; {JoinLastLigTables}

