/*
 * Decompiled with CFR 0.152.
 */
package nts.io;

import nts.io.BaseLineOutput;
import nts.io.CharCode;
import nts.io.Log;
import nts.io.Loggable;

public final class BufferLineOutput
extends BaseLineOutput
implements Loggable,
CharCode.CodeWriter {
    private CharCode[] buffer;
    private int maxCount;
    private int pos;
    private CharCode.Maker maker;

    public void add(CharCode code) {
        code.writeExpCodes(this);
    }

    public void add(char chr) {
        this.maker.writeExpCodes(chr, this);
    }

    public void writeCode(CharCode code) {
        if (this.maxCount <= 0 || this.pos < this.maxCount) {
            this.buffer[this.pos++ % this.buffer.length] = code;
        }
        ++this.charCount;
    }

    public void reset() {
        int i = 0;
        while (i < this.buffer.length) {
            this.buffer[i++] = null;
        }
        this.pos = 0;
        this.resetCount();
    }

    public int size() {
        return this.pos <= this.buffer.length ? this.pos : this.buffer.length;
    }

    public void addOn(Log log, int idx) {
        log.add(this.codeAt(idx));
    }

    public void addOn(Log log, int beg, int end) {
        while (beg < end) {
            log.add(this.codeAt(beg++));
        }
    }

    public void addOn(Log log) {
        this.addOn(log, 0, this.size());
    }

    private CharCode codeAt(int idx) {
        if (idx >= 0) {
            if (this.pos <= this.buffer.length) {
                if (idx < this.pos) {
                    return this.buffer[idx];
                }
            } else if (idx < this.buffer.length) {
                return this.buffer[(this.pos + idx) % this.buffer.length];
            }
        }
        throw new ArrayIndexOutOfBoundsException("BufferLineOutput: index out of range: " + idx);
    }

    public BufferLineOutput(int size, int maxCount, CharCode.Maker maker) {
        this.buffer = new CharCode[size];
        this.maxCount = maxCount;
        this.maker = maker;
        this.pos = 0;
    }
}

